@extends('frontend.layouts.main')

@section('title')
    {{ __('Security') }}
@endsection

@section('content')
    <div class="card border-primary mb-3">
        <div class="card-body">
            <h5 class="card-title">{{ __('Two-factor authentication') }}</h5>
            <p class="text-muted">
                {{ __('2-step verification provides stronger security for your account by requiring a second step of verification when you sign in.') }}
                {{ __('In addition to your password, you will also need a code generated by the Google Authenticator app on your phone.') }}
                {{ __('It is strongly recommended to enable two-factor authentication to protect your account.') }}
            </p>
            @if(auth()->user()->totp_secret)
                <a href="{{ route('frontend.security.2fa.disable') }}" class="btn btn-danger">{{ __('Disable 2FA') }}</a>
            @else
                <a href="{{ route('frontend.security.2fa.enable') }}" class="btn btn-primary">{{ __('Enable 2FA') }}</a>
            @endif
        </div>
    </div>
@endsection